[Code]
(*Inno Tools Downloader DLL
Copyright (C) Sherlock Software 2006
Version 0.1 Alpha

Usage:
 - Copy it_download.iss and itdownload.dll to the same folder as your script
 - Add #Include <it_download.iss> on a blank line outside of all sections
 - Call itd_initui(); in your InitializeWizard() procedure
 - At any time, call itd_addfile(), itd_clearfiles() methods to add files to be downloaded.
   A typical itd_addfile call looks like: itd_addfile('http://www.mywebsite.com/file.jpg',expandconstant('{tmp}\file.jpg'));
   You must give the full url and full destination path
 - The files will be downloaded as part of the install process, after wpReady

Options:
 At any time, you can call itd_setoption() with the following values:

  OPTION                 VALUES      DEFAULT   MEANING

  Debug_DownloadDelay      Any number  0         Numbers larger than 0 slow down your downloads.
  Debug_Messages           0 or 1      0         Turns on detailed error message popups for debugging
  ITD_NoCache              0 or 1      0         If 1, never read files from the internet
                                                 cache, always download them
  UI_Caption               String      See code  Sets the caption of the download page
  UI_Description           String      See code  Sets the description of the download page
  UI_AllowContinue         0 or 1      0         Allow the user to continue install if the download fails
  UI_FailMessage           String      See code  Sets the message that appears when a download fails,
                                                 and the user can either retry or exit
  UI_FailOrContinueMessage String      See code  Sets the message that appears when download fails,
                                                 and the user can continue, retry or exit.


 You can also query options with itd_getoption().
 Querying option 'ITD_Version' gives you the version number of the DLL.

Notes:
 - Does not yet support resume
 - Incomplete files will be deleted
 - FTP and HTTP supported
 - Usernames, passwords and port numbers can be provided as part of the URL

Typical session:
  itd_initui() in InitializeWizard();
  itd_setoption() to choose options
  Multiple itd_addfile() calls
  You do not need to manually call itd_downloadfiles()

UI-less:
 If you want to download files without a UI, don't call itd_initui.
 Call itd_downloadfiles() to start the download.
 You can cancel the download with itd_cancel().

Contact:
 The author, Nicholas Sherlock, at N_sherlock@ihug.co.nz. Comments, questions and suggestions welcome.

Website:
 http://www.sherlocksoftware.org
*)

procedure itd_internal_initui(HostHwnd: dword);
  external 'itd_initui@files:itdownload.dll stdcall';

procedure itd_internal_setoption(option, value: PChar);
  external 'itd_setoption@files:itdownload.dll stdcall';

function itd_internal_getoption(option: PChar; buffer: PChar; length: integer): integer;
  external 'itd_getoption@files:itdownload.dll stdcall';

function itd_download(url: PChar; destfilename: PChar): integer;
  external 'itd_download@files:itdownload.dll stdcall';

procedure itd_addfile(url: PChar; destfilename: PChar);
  external 'itd_addfile@files:itdownload.dll stdcall';

function itd_downloadfiles: integer;
  external 'itd_downloadfiles@files:itdownload.dll stdcall';

procedure itd_clearfiles;
  external 'itd_clearfiles@files:itdownload.dll stdcall';

function itd_filecount: integer;
  external 'itd_filecount@files:itdownload.dll stdcall';

procedure itd_cancel;
  external 'itd_cancel@files:itdownload.dll stdcall';

const
  ITDERR_SUCCESS = 0;
  ITDERR_USERCANCEL = 1;
  ITDERR_ERROR = 3;

var itd_downloadpage: TWizardPage;
  itd_options: record
    caption, description, failmessage, failretryorcontinue: string;
    allowcontinue: boolean;
  end;
  itd_retryonback: boolean;

function itd_handleskippage(sender: TWizardPage): boolean;
begin
  result := (itd_filecount = 0);
end;

procedure itd_nowdodownload;
var err: integer;
begin
  wizardform.backbutton.enabled := false;
  wizardform.nextbutton.enabled := false;

  err := itd_downloadfiles;

  case err of
    ITDERR_SUCCESS: begin
        wizardform.nextbutton.enabled := true;
        wizardform.nextbutton.onclick(nil);
      end;
    ITDERR_USERCANCEL: ; //Don't show a message, this happens on setup close and cancel click
  else begin
    //Some unexpected error
      wizardform.backbutton.caption := 'Retry';
      wizardform.backbutton.enabled := true;
      wizardform.backbutton.show();
      itd_retryonback := true;

      if itd_options.allowcontinue then begin //Download failed, we can retry, continue, or exit
        wizardform.nextbutton.enabled := true;
        if length(itd_options.failretryorcontinue) = 0 then
          MsgBox('Sorry, the files could not be downloaded. Click retry to try downloading the files again, or click next to continue installing anyway.', mbError, MB_OK)
        else
          MsgBox(itd_options.failretryorcontinue, mbError, MB_OK);
      end else begin //Download failed, we must retry or exit setup
        if length(itd_options.failmessage) = 0 then
          MsgBox('Sorry, the files could not be downloaded. Click retry to try downloading the files again, or click cancel to terminate setup.', mbError, MB_OK)
        else
          MsgBox(itd_options.failmessage, mbError, MB_OK);
      end;
    end;
  end;
end;

procedure itd_handleshowpage(sender: TWizardPage);
begin
  wizardform.nextbutton.enabled := false;
  wizardform.backbutton.hide();

  itd_nowdodownload;
end;

function itd_handlebackclick(sender: TWizardpage): boolean;
begin
  result := false;
  if itd_retryonback then begin
    itd_retryonback := false;
    itd_nowdodownload;
  end;
end;

procedure itd_initui;
begin
  if length(itd_options.caption) = 0 then
    itd_options.caption := 'Downloading additional files';
  if length(itd_options.description) = 0 then
    itd_options.description := 'Please wait while setup downloads additional files...';

  itd_downloadpage := createcustompage(wpReady, itd_options.caption, itd_options.description);

  itd_downloadpage.onactivate := @itd_handleshowpage;
  itd_downloadpage.onshouldskippage := @itd_handleskippage;
  itd_downloadpage.onbackbuttonclick := @itd_handlebackclick;
  itd_internal_initui(itd_downloadpage.surface.handle);
end;

procedure itd_setoption(const option, value: string);
begin
  if comparetext(option, 'UI_Caption') = 0 then begin
    itd_options.caption := value;
    if itd_downloadpage <> nil then
      itd_downloadpage.caption := value;
  end else
    if comparetext(option, 'UI_Description') = 0 then begin
      itd_options.description := value;
      if itd_downloadpage <> nil then
        itd_downloadpage.description := value;
    end else
      if comparetext(option, 'UI_FailMessage') = 0 then
        itd_options.failmessage := value else
        if comparetext(option, 'UI_FailOrContinueMessage') = 0 then
          itd_options.failretryorcontinue := value else
          if comparetext(option, 'UI_AllowContinue') = 0 then
            itd_options.allowcontinue := (value = '1') else
            itd_internal_setoption(option, value);
end;

function itd_getoption(const option: string): string;
begin
  setlength(result, 300);
  setlength(result, itd_internal_getoption(pchar(option), pchar(result), length(result)));
end;


[Files]
Source: itdownload.dll; Flags: dontcopy; DestDir: {tmp}
